/*!
 * Matomo - free/libre analytics platform
 *
 * @link    https://matomo.org
 * @license https://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */

import './noAdblockFlag';
import './Periods/Day';
import './Periods/Week';
import './Periods/Month';
import './Periods/Year';
import './Periods/Range';
import './AjaxHelper/AjaxHelper.adapter';
import './PopoverHandler/PopoverHandler';
import './zenMode';
import Matomo from './Matomo/Matomo';

export { default as createVueApp } from './createVueApp';
export { default as importPluginUmd } from './importPluginUmd';
export { default as useExternalPluginComponent } from './useExternalPluginComponent';
export { default as DirectiveUtilities } from './directiveUtilities';
export { default as debounce } from './debounce';
export { default as getFormattedEvolution } from './getFormattedEvolution';
export { default as clone } from './clone';
export { default as VueEntryContainer } from './VueEntryContainer/VueEntryContainer.vue';
export { default as ActivityIndicator } from './ActivityIndicator/ActivityIndicator.vue';
export { default as MatomoLoader } from './MatomoLoader/MatomoLoader.vue';
export * from './translate';
export * from './externalLink';
export { default as Alert } from './Alert/Alert.vue';
export { default as AjaxHelper, AjaxOptions } from './AjaxHelper/AjaxHelper';
export { setCookie, getCookie, deleteCookie } from './CookieHelper/CookieHelper';
export { default as MatomoUrl } from './MatomoUrl/MatomoUrl';
export { Matomo };
export * from './Periods';
export { default as DropdownMenu } from './DropdownMenu/DropdownMenu';
export { default as FocusAnywhereButHere } from './FocusAnywhereButHere/FocusAnywhereButHere';
export { default as FocusIf } from './FocusIf/FocusIf';
export { default as Tooltips } from './Tooltips/Tooltips';
export { default as MatomoDialog } from './MatomoDialog/MatomoDialog.vue';
export { default as ExpandOnClick } from './ExpandOnClick/ExpandOnClick';
export { default as ExpandOnHover } from './ExpandOnHover/ExpandOnHover';
export { default as ShowSensitiveData } from './ShowSensitiveData/ShowSensitiveData';
export { default as DropdownButton } from './DropdownButton/DropdownButton';
export { default as SelectOnFocus } from './SelectOnFocus/SelectOnFocus';
export { default as CopyToClipboard } from './CopyToClipboard/CopyToClipboard';
export { default as SideNav } from './SideNav/SideNav';
export { default as EnrichedHeadline } from './EnrichedHeadline/EnrichedHeadline.vue';
export { default as ContentBlock } from './ContentBlock/ContentBlock.vue';
export { default as Comparisons } from './Comparisons/Comparisons.vue';
export { default as ComparisonsStore } from './Comparisons/Comparisons.store';
export { default as ComparisonsStoreInstance } from './Comparisons/Comparisons.store.instance';
export { default as MenuItemsDropdown } from './MenuItemsDropdown/MenuItemsDropdown.vue';
export { default as DatePicker } from './DatePicker/DatePicker.vue';
export { default as DateRangePicker } from './DateRangePicker/DateRangePicker.vue';
export { default as PeriodDatePicker } from './PeriodDatePicker/PeriodDatePicker.vue';
export * from './Notification';
export { default as ShowHelpLink } from './ShowHelpLink/ShowHelpLink.vue';
export { default as SitesStore } from './SiteSelector/SitesStore';
export { default as Site } from './SiteSelector/Site';
export { default as SiteSelector } from './SiteSelector/SiteSelector.vue';
export { default as SiteRef } from './SiteSelector/SiteRef';
export { default as QuickAccess } from './QuickAccess/QuickAccess.vue';
export { default as FieldArray } from './FieldArray/FieldArray.vue';
export { default as MultiPairField } from './MultiPairField/MultiPairField.vue';
export { default as PeriodSelector } from './PeriodSelector/PeriodSelector.vue';
export { default as ReportingMenu } from './ReportingMenu/ReportingMenu.vue';
export { default as ReportingMenuStore } from './ReportingMenu/ReportingMenu.store';
export { default as ReportingPagesStore } from './ReportingPages/ReportingPages.store';
export { default as ReportMetadataStore } from './ReportMetadata/ReportMetadata.store';
export { default as WidgetsStore } from './Widget/Widgets.store';
export { default as WidgetLoader } from './WidgetLoader/WidgetLoader.vue';
export { default as WidgetContainer } from './WidgetContainer/WidgetContainer.vue';
export {
  default as WidgetByDimensionContainer,
} from './WidgetByDimensionContainer/WidgetByDimensionContainer.vue';
export { default as Widget } from './Widget/Widget.vue';
export {
  Widget as WidgetType,
  WidgetContainer as WidgetContainerType,
  GroupedWidgets as GroupedWidgetsType,
} from './Widget/types';
export { default as ReportingPage } from './ReportingPage/ReportingPage.vue';
export { default as ReportExport } from './ReportExport/ReportExport';
export { default as Sparkline } from './Sparkline/Sparkline.vue';
export { default as Progressbar } from './Progressbar/Progressbar.vue';
export { default as ContentIntro } from './ContentIntro/ContentIntro';
export { default as ContentTable } from './ContentTable/ContentTable';
export { default as AjaxForm } from './AjaxForm/AjaxForm.vue';
export { default as Passthrough } from './Passthrough/Passthrough.vue';
export { default as DataTableActions } from './DataTable/DataTableActions.vue';
export {
  default as VersionInfoHeaderMessage,
} from './VersionInfoHeaderMessage/VersionInfoHeaderMessage.vue';
export { default as MobileLeftMenu } from './MobileLeftMenu/MobileLeftMenu.vue';
export { default as scrollToAnchorInUrl } from './scrollToAnchorInUrl';
