<?php
/**
 * Matomo - free/libre analytics platform
 *
 * @link https://matomo.org
 * @license http://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */
namespace Piwik\Plugins\TagManager\Template\Variable\PreConfigured;

use Piwik\Plugins\TagManager\Context\WebContext;


class RandomNumberVariable extends BasePreConfiguredVariable
{
    public function getCategory()
    {
        return self::CATEGORY_UTILITIES;
    }

    public function loadTemplate($context, $entity, $skipTemplate = false)
    {
        switch ($context) {
            case WebContext::ID:
                return $this->makeReturnTemplateMethod('Math.floor(Math.random() * 20000000000)', $skipTemplate);
        }
    }

}
